///
/// Nanotec Nanolib example
/// Copyright (C) Nanotec GmbH & Co. KG - All Rights Reserved
///
/// This product includes software developed by the
/// Nanotec GmbH & Co. KG (http://www.nanotec.com/).
///
/// The Nanolib interface headers and the examples source code provided are 
/// licensed under the Creative Commons Attribution 4.0 Internaltional License. 
/// To view a copy of this license, 
/// visit https://creativecommons.org/licenses/by/4.0/ or send a letter to 
/// Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
///
/// The parts of the library provided in binary format are licensed under 
/// the Creative Commons Attribution-NoDerivatives 4.0 International License. 
/// To view a copy of this license, 
/// visit http://creativecommons.org/licenses/by-nd/4.0/ or send a letter to 
/// Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
///
/// This program is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
///
/// <file_name>LoggingFunctionsExample.cs</file_name>
///
/// <summary>Definition of logging functions</summary>
///
/// <date>29-10-2024</date>
///
/// <author>Michael Milbradt<author>
///

using MenuUtils;
using Nlc;

namespace LoggingFunctionsExample
{

    public static class LoggingFunctions
    {
        /// <summary>
        /// Sets the log level to use (spdlog).
        /// </summary>
        /// <param name="ctx">The menu context.</param>
        public static void SetLogLevel(Context ctx)
        {
            ctx.WaitForUserConfirmation = false;
            int index = ctx.SelectedOption;

            switch (index)
            {
                case 1:
                    ctx.NanolibAccessor.setLoggingLevel(LogLevel.Trace);
                    ctx.CurrentLogLevel = LogLevel.Trace;
                    break;
                case 2:
                    ctx.NanolibAccessor.setLoggingLevel(LogLevel.Debug);
                    ctx.CurrentLogLevel = LogLevel.Debug;
                    break;
                case 3:
                    ctx.NanolibAccessor.setLoggingLevel(LogLevel.Info);
                    ctx.CurrentLogLevel = LogLevel.Info;
                    break;
                case 4:
                    ctx.NanolibAccessor.setLoggingLevel(LogLevel.Warning);
                    ctx.CurrentLogLevel = LogLevel.Warning;
                    break;
                case 5:
                    ctx.NanolibAccessor.setLoggingLevel(LogLevel.Error);
                    ctx.CurrentLogLevel = LogLevel.Error;
                    break;
                case 6:
                    ctx.NanolibAccessor.setLoggingLevel(LogLevel.Critical);
                    ctx.CurrentLogLevel = LogLevel.Critical;
                    break;
                case 7:
                    ctx.NanolibAccessor.setLoggingLevel(LogLevel.Off);
                    ctx.CurrentLogLevel = LogLevel.Off;
                    break;
                default:
                    ctx.NanolibAccessor.setLoggingLevel(LogLevel.Info);
                    ctx.CurrentLogLevel = LogLevel.Info;
                    break;
            }
        }

        /// <summary>
        /// Sets the logging callback for the selected option.
        /// </summary>
        /// <param name="ctx">The menu context.</param>
        public static void SetLoggingCallback(Context ctx)
        {
            ctx.WaitForUserConfirmation = false;
            int index = ctx.SelectedOption;

            switch (index)
            {
                case 1:
                    ctx.NanolibAccessor.setLoggingCallback(ctx.LoggingCallback, LogModule.NanolibCore);
                    ctx.CurrentLogModule = LogModule.NanolibCore;
                    ctx.LoggingCallbackActive = true;
                    break;
                case 2:
                    ctx.NanolibAccessor.setLoggingCallback(ctx.LoggingCallback, LogModule.NanolibCANopen);
                    ctx.CurrentLogModule = LogModule.NanolibCANopen;
                    ctx.LoggingCallbackActive = true;
                    break;
                case 3:
                    ctx.NanolibAccessor.setLoggingCallback(ctx.LoggingCallback, LogModule.NanolibEtherCAT);
                    ctx.CurrentLogModule = LogModule.NanolibEtherCAT;
                    ctx.LoggingCallbackActive = true;
                    break;
                case 4:
                    ctx.NanolibAccessor.setLoggingCallback(ctx.LoggingCallback, LogModule.NanolibModbus);
                    ctx.CurrentLogModule = LogModule.NanolibModbus;
                    ctx.LoggingCallbackActive = true;
                    break;
                case 5:
                    ctx.NanolibAccessor.setLoggingCallback(ctx.LoggingCallback, LogModule.NanolibRest);
                    ctx.CurrentLogModule = LogModule.NanolibRest;
                    ctx.LoggingCallbackActive = true;
                    break;
                case 6:
                    ctx.NanolibAccessor.setLoggingCallback(ctx.LoggingCallback, LogModule.NanolibUSB);
                    ctx.CurrentLogModule = LogModule.NanolibUSB;
                    ctx.LoggingCallbackActive = true;
                    break;
                default:
                    ctx.NanolibAccessor.unsetLoggingCallback();
                    ctx.LoggingCallbackActive = false;
                    break;
            }
        }
    }
}
