# Nanolib

This is the C# version of the NanoLib Nuget-Repository with an example application. <br>
The NanoLib offers an easy to use library to control Nanotec devices.

[www.nanotec.de](https://www.nanotec.de/)

## Example Application
### Overview and Structure
The CLI example application provides a menu interface where the user can execute
the different library functions. The menu offers the user the possibility to <br>
easily and quickly select and execute all functions supported by NanoLib. <br>
The menu entries are context based and will be enabled or disabled, depending on
the state.<br>
To enable all entries you have to:
1. Scan for hardware buses
2. Connect to a found harwdare bus
3. Scan for devices on the opened hardware bus
4. Successfully connect to a found device<br>
 
With this example application it is possible to:<br> 
- do a hardware bus scan
- open a found bus hardware (several hardware buses allowed)
- close an opened bus hardware
- scan for devices on opened hardware bus(es)
- connect to a found device (several devices allowed)
- disconnect from a connected device 
- read device informations
- update the firmware
- update the bootloader
- upload a NanoJ program
- run/stop a NanoJ program
- reboot a device
- set logging and logging callback parameters
- auto tune a motor (may require manual steps before)
- get a motor to rotate
- use the object dicationary interface for reads/writes
- sample data
- scan for Profinet devices
- etc.

The application menu and the supported NanoLib functionality is logically structered into several files:<br>
Files with \*FunctionsExample.cs contain the implementations for the NanoLib interface functions.<br>
Files with \*CallbackExample.cs contain implementations for the various callbacks (scan, data and logging).<br>
Files with Menu\*.cs contain the menu logic and code.<br>
Example.cs is the main program, creating the menu and initializing all used parameters.<br>
SamplerExampleClass.cs contains the example implementation for sampler usage.<br>

### Windows
#### Prerequisites
- Install [Microsoft Visual Studio (Community) 2022](https://visualstudio.microsoft.com/de/vs/community/) or later with .NET Desktop Development
- Install [HMS - Ixxat VCI 4 driver](https://hmsnetworks.blob.core.windows.net/nlw/docs/default-source/products/ixxat/monitored/pc-interface-cards/vci-v4-0-1240-windows-11-10.zip?sfvrsn=2d1dfdd7_69) and connect CAN adapter (optional).
- Install [PEAK device driver and PCAN API](https://www.peak-system.com/quick/DrvSetup) and connect CAN adapter (optional).
- Connect all devices to your adapter(s) according to the user manual and power on the devices.

#### Compiling and running the example project
- Open the file ```Example.sln``` (below NanolibExample) with Visual Studio. The main file for the example is ```Example.cs```.
- Wait some seconds until the loading of the project is complete.
- Compile and run the example code.
  
#### Compiling and running the nanolib in your own project
##### Prerequisites
- If not already done, unpack all files and folders of the nanolib_csharp_win_#.#.#.zip file.
- Create a folder for your local project - Example: ```C:\NugetRepo```

##### Create new project
- Open Visual Studio 2022, on the welcome screen click on "Create new project".
- You can now choose the type of the project. Choose "Console App (.NET Framework) - C#", click next.
- You now need to give the project a name (e.g. "NanolibTest") and set its location to your local project folder.<br>Select Framework: .NET Framework 4.7.2 or higher.
- Click on "Create"
- Add Nanolib Nuget Package by Right-Click on your project -> Manage Nuget Packages... -> Browse -> nanotec.services.nanolib -> Choose the latest Version and click "Install"
- If you cannot see the Nanolib-Nuget-Package your "Package source" might not be selected
- Set the Target Platform to x64 -> Right Click on your project -> Properties -> Build ->Platform target: x64

##### Test and Compile
- Open the main (Program.cs in this example) and replace the text with the following code:
 ```c++
class Program
{
        static void Main(string[] args)
        {
            nlc.NanoLibAccessor accessor = nlc.Nanolib.getNanoLibAccessor();
        }
 }
 ```
- Go to the menu "Build" and choose "Build solution"
 In the compile output window, there should be no error but something like
```
========== Build: 1 succeeded, 0 failed, 0 up-to-date, 0 skipped ==========
```
