/*
This NanoJ Example Code is based on our experience with typical user requirements in a wide range
of industrial applications and is provided without guarantee regarding correctness and completeness.
It serves as general guidance and should not be construed as a commitment of Nanotec to guarantee its
applicability to the customer application without additional tests under the specific conditions
and – if and when necessary – modifications by the customer. 

The responsibility for the applicability and use of the NanoJ Example Code in a particular
customer application lies solely within the authority of the customer.
It is the customer's responsibility to evaluate, investigate and decide,
whether the Example Code is valid and suitable for the respective customer application, or not.
Defects resulting from the improper handling of devices and modules are excluded from the warranty.
Under no circumstances will Nanotec be liable for any direct, indirect, incidental or consequential damages
arising in connection with the Example Code provided. In addition, the regulations regarding the
liability from our Terms and Conditions of Sale and Delivery shall apply.
*/

// This NanoJ program is using the Profile Velocity in order to turn the motor back and forth (reversing mode)
// The Velocities, Ramps and Times are set using defines.

// You can map frequently used objects to be able to read or write them
// using In.* and Out.*. Here we map the object 6041:00 as "In.StatusWord".
// You can map frequently used objects to be able to read or write them
map U16 Controlword as inout 0x6040:00
map U16 Statusword as input 0x6041:00 
map U32 Inputs as input 0x60FD:00 
map U32 Outputs as inout 0x60FE:01
map S08 ModesOfOperation as output 0x6060:00 
map S08 ModesOfOperationDisplay as input 0x6061:00 
map S16 AnalogInput as input 0x3220:01 

// MAPPINGS FOR PROFILE VELOCITY
map S32 TargetVelocity as inout 0x60FF:00
map U32 ProfileAcceleration as inout 0x6083:00
map U32 ProfileDeceleration as inout 0x6084:00
map U32 QuickStopDeceleration as inout 0x6085:00
map U32 MaxAcceleration as inout 0x60C5:00
map U32 MaxDeceleration	as inout 0x60C6:00

// Include the definition of NanoJ functions and symbols
#include "wrapper.h"
// Include the NanoJ V2 Library
#include "nanotec.h"


////////// USER INTERFACE //////////

// TARGET VELOCITIES FOR LEFT AND RIGHT DIRECTION: 
#define TARGET_VELOCITY_POSITIVE_DIRECTION                       4500				
#define TARGET_VELOCITY_NEGATIVE_DIRECTION                      -4500			

// TIME PARAMETERS FOR RIGHT AND LEFT DRIVE
#define TIME_POSITIVE_DIRECTION                                  300			
#define TIME_NEGATIVE_DIRECTION                                  300				

// ACCELERATION PARAMETERS
#define PROFILE_ACCELERATION_POSITIVE_DIRECTION                  50000				
#define PROFILE_ACCELERATION_NEGATIVE_DIRECTION                  50000
#define PROFILE_DECELERATION_POSITIVE_DIRECTION                  50000
#define PROFILE_DECELERATION_NEGATIVE_DIRECTION                  50000

// ACCELERATION LIMITS
#define MAX_DECELERATION                                         100000
#define MAX_ACCELERATION                                         100000
		
////////// END OF USER INTERFACE //////////

// The user() function is the entry point of the NanoJ program. It is called
// by the firmware of the controller when the NanoJ program is started.
void user()
{

	// Sets Acceleration Limits: 
	InOut.MaxAcceleration = MAX_ACCELERATION; 
	InOut.MaxDeceleration = MAX_DECELERATION; 

	// Sets mode "Profile velocity" and starts Operation
	ModesOfOperation(3); 	
	EnableOperation(); 
	
	while(true)
	{		
		// Sets Velocity, Ramps and Time for the positive Direction
		InOut.TargetVelocity = TARGET_VELOCITY_POSITIVE_DIRECTION; 
		InOut.ProfileAcceleration = PROFILE_ACCELERATION_POSITIVE_DIRECTION; 
		InOut.ProfileDeceleration = PROFILE_DECELERATION_POSITIVE_DIRECTION;
		sleep(TIME_POSITIVE_DIRECTION); 

		// Sets Velocity, Ramps and Time for the negative Direction		
		InOut.TargetVelocity = TARGET_VELOCITY_NEGATIVE_DIRECTION;  
		InOut.ProfileAcceleration = PROFILE_ACCELERATION_NEGATIVE_DIRECTION; 
		InOut.ProfileDeceleration = PROFILE_DECELERATION_NEGATIVE_DIRECTION; 			
		sleep(TIME_NEGATIVE_DIRECTION); 	
	}
}