/*
This NanoJ Example Code is based on our experience with typical user requirements in a wide range
of industrial applications and is provided without guarantee regarding correctness and completeness.
It serves as general guidance and should not be construed as a commitment of Nanotec to guarantee its
applicability to the customer application without additional tests under the specific conditions
and - if and when necessary - modifications by the customer. 

The responsibility for the applicability and use of the NanoJ Example Code in a particular
customer application lies solely within the authority of the customer.
It is the customer's responsibility to evaluate, investigate and decide,
whether the Example Code is valid and suitable for the respective customer application, or not.
Defects resulting from the improper handling of devices and modules are excluded from the warranty.
Under no circumstances will Nanotec be liable for any direct, indirect, incidental or consequential damages
arising in connection with the Example Code provided. In addition, the regulations regarding the
liability from our Terms and Conditions of Sale and Delivery shall apply.
*/

// This example shows how to setup and start a homing-routine. 
// The purpose of the homing method is to define the zero-position in your application

// You can map frequently used objects to be able to read or write them using In.* and Out.*. 
 
map U16 Controlword as inout 0x6040:00
map U16 Statusword as input 0x6041:00 
map U32 Inputs as input 0x60FD:00 
map U32 Outputs as inout 0x60FE:01 
map S08 ModesOfOperation as output 0x6060:00 
map S08 ModesOfOperationDisplay as input 0x6061:00 
map S16 AnalogInput as input 0x3220:01 

#include "wrapper.h"
#include "nanotec.h"


void user()
{
	//Activation of the Homing operation mode:
	ModesOfOperation(6); 
	od_write(0x6098, 0x00, 35);			//Homing Method, please refer to the manual to select the method, fitting your applicaiotn
	yield();
	
	od_write(0x6099, 0x01, 50);			//Homing Speed: Speed During Search For Switch
	od_write(0x6099, 0x02, 10);			//Homing Speed: Speed During Search For Zero
	od_write(0x609A, 0x00, 500);		//Homing Acceleration
	yield();
	
	od_write(0x203A, 0x01, 0xFFFFFFBA);	//Homing On Block Configuration: Minimum Curren for Block Detection (only for Homing on Block)				
	od_write(0x203A, 0x02, 200);		//Homing On Block Configuration: Block Detection Time (only for Homing on Block)
	yield();
	
	od_write(0x3240, 0x01, 7);			//Digital Inputs Control: Special Function Enable (only for Homing on Switches)	
	od_write(0x607C, 0x00, 0);			//Home Offset
	yield(); 
		
	EnableOperation();					//switch to Operation Enabled
	NewSetPoint(true);  				//start the Homing
	
	while(!TargetReached() & !NewSetPointAcknowledge()) //wait while homing is not complete (Bit 10 and Bit 12 are not set yet)
	{ 
		yield(); 		
	}

	NewSetPoint(false);  	
	Shutdown(); 						//switch off
	
	od_write(0x2300, 0x00, 0);			//stop the NanoJ-Program
	yield();
}


